<!DOCTYPE html>
<html>
	<head>
		<title>Standalone Leoclock</title>
		<style type="text/css">
			/* You don't need this CSS, it's just to make the default styling of this file a bit nicer. Of course, if you just point an iframe file to this file you might want to tweak this. */
			body{font-family: Arial,Helvetica,Sans-Serif; font-size: 14px; margin: 0px; padding: 0px; text-align:center;}
			a:link{text-decoration: underline;color: #89B6C8;}
			a:visited, a.visited{text-decoration: underline;color: #4E8DA6;}
			a:hover, a.hover{text-decoration: none;color: #F42A34;			}
		</style>
	</head>
	<body>
		<?php
			//I'm assuming that if you downloaded this version you have at least a basic understanding of HTML, CSS and PHP, possibly some javascript.
			//Two easy ways to use this. Put all the files here in their own directory and link an iframe to it OR put the php code below on your site where you want the clock.
		
			/**
			 * @package LeoClock Standalone
			 * @version 1.3.0
			 * @author Hampus Jensen (http://leonick.se)
			 * @copyright (C) 2012-2014 Hampus Jensen
			 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
			**/
			
			//Contains function needed to make the clock. You only need to include this once.
			require_once("leoclock_helper.php");
										
			//Parameters are passed as an associative array. You don't have to set any of the parameters. 
			//If a value hasn't been set by the user, the values below are what is used.
			$params	= array(
									"diff" 					=> "default",
									//If you plan to use multiple instances of leoclock on your site make sure this is different for each one, it makes it able to tell the instances apart.
									"TZ" 					=> "Europe/London",	
									//Should be a valid php date() timezone, complete list found at http://php.net/manual/en/timezones.php
									"showTZ" 			=> "yes",			
									//Yes shows timezone, anything else is treated as no.
									"TZformat" 			=> "full",		
									//Set in what format timezone should be displayed, "full" shows continent and city, "city" only shows the city, set to "custom" if you want to use a custom output set below.
									"customTZ" 		=> "",			
									//If you set timezone format to custom this is where you set what should be displayed.
									"timeFormat" 		=> "24h",		
									//Timezone format, '24h' or '12h'.
									"showSeconds" 	=> "yes",		
									//Should secons be shown? 'yes' or 'no'.
									"leadingZeros"		=> "yes",	
									//Do you want leading zeroes? 'yes', nothour' or 'no'. Yes shows all leading zeros. Nothour remove it from hour and date. No removes all leading zeros.
									"dateFormat" 		=> "format1",);	
									//Date format, the following are available:
															//"no", date will not be displayed.
															//"format1", (YYYY-MM-DD)
															//"format2", (YYYY/MM/DD)
															//"format3", (DD/MM/YYYY)
															//"format4", (MM/DD/YYYY)
															//"format5", (16 Jan)
															//"format6", (Wed 16 Jan)
															//"format7", (Jan 16)
															//"format8", (Jan 16, 2013)
															//"format9", (Wed Jan 16)
								  
			
			//makes the clock using the options specified above.
			LeoClockHelper::makeLeoclock ($params);
		?>
	</body>
</html>