<?php
/**
 * @package LeoClock Standalone
 * @version 1.3.0
 * @author Hampus Jensen (http://leonick.se)
 * @copyright (C) 2012-2014 Hampus Jensen
 * @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
**/

class LeoClockHelper{
	//Gets the current time for given timezone and formats it for use with javascript
    function getTime( $timezone ){
		date_default_timezone_set($timezone); 
		$time=date("F d, Y H:i:s");
        return $time;
    }
	
	//Handles the formatting of the displayed timezone.
	function getOutputTimezone( $timezone, $timezoneFormat="full", $customTimezone ){
		$timezoneOut=$timezone;
		if($timezoneFormat=="full"){
			$timezoneOut = str_replace("Indian/","Indian Ocean, ",$timezoneOut);
			$timezoneOut = str_replace("Pacific/","Pacific Ocean, ",$timezoneOut);
			$timezoneOut = str_replace("Atlantic/","Atlantic Ocean, ",$timezoneOut);
			$timezoneOut = str_replace("/",", ",$timezoneOut);
		}
		elseif($timezoneFormat=="city"){
			$timezoneOut = str_replace("Africa/","",$timezoneOut);
			$timezoneOut = str_replace("America/","",$timezoneOut);
				$timezoneOut = str_replace("Argentina/","",$timezoneOut);
				$timezoneOut = str_replace("Indiana/","",$timezoneOut);
				$timezoneOut = str_replace("Kentucky/","",$timezoneOut);
				$timezoneOut = str_replace("North_Dakota/","",$timezoneOut);
			$timezoneOut = str_replace("Antarctica/","",$timezoneOut);
			$timezoneOut = str_replace("Arctic/","",$timezoneOut);
			$timezoneOut = str_replace("Asia/","",$timezoneOut);
			$timezoneOut = str_replace("Atlantic/","",$timezoneOut);
			$timezoneOut = str_replace("Australia/","",$timezoneOut);
			$timezoneOut = str_replace("Europe/","",$timezoneOut);
			$timezoneOut = str_replace("Indian/","",$timezoneOut);
			$timezoneOut = str_replace("Pacific/","",$timezoneOut);
		}
		elseif($timezoneFormat=="custom"){
			$timezoneOut=$customTimezone;
		}
		$timezoneOut = str_replace("_"," ",$timezoneOut);
        return $timezoneOut;
    }
}

//Creates the clock.
function makeLeoclock ($params){
	$LeoClockHelper = new LeoClockHelper();

	//default values
	if(!isset($params)){ $params = array(); }
	if(!isset($params['diff'])){ 					$params['diff']					="default"; }
	if(!isset($params['TZ'])){ 					$params['TZ']					="Europe/London"; }
	if(!isset($params['showTZ'])){ 			$params['showTZ']			="yes"; }
	if(!isset($params['TZformat'])){ 			$params['TZformat']			="full"; }
	if(!isset($params['customTZ'])){ 		$params['customTZ']		=""; }
	if(!isset($params['timeFormat'])){ 		$params['timeFormat']		="24h"; }
	if(!isset($params['showSeconds'])){ 	$params['showSeconds']	="yes"; }
	if(!isset($params['leadingZeros'])){ 		$params['leadingZeros']		="yes"; }
	if(!isset($params['dateFormat'])){ 		$params['dateFormat']		="format1"; }	
	
	$moduleTitle = strtolower($params['diff']);
	$moduleTitle = preg_replace('/[\/\\\\\!"@#£¤$%&(){}[\]=+?´`¨^~\'*-.,:;€<>| ]/i', '_', $moduleTitle);
	$time = $LeoClockHelper->getTime( $params['TZ'] );
	$outTimezone = $LeoClockHelper->getOutputTimezone( $params['TZ'], $params['TZformat'], $params['customTZ'] );
	
	include("leoclock.php");
}

?>