; PowerPlanner by Leonick - leonick.se/projects/powerplanner
#NoEnv
#SingleInstance, Force
Menu, Tray, NoStandard

Start:
IniRead, Mode, PowerPlanner.ini, State, ManualMode, Unset
IniRead, Automatic, PowerPlanner.ini, State, Automatic, 1
IniRead, performancePlan, PowerPlanner.ini, Settings, PerformancePlan, AMD Ryzen Balanced
IniRead, performanceGUID, PowerPlanner.ini, Settings, PerformanceGUID, 0
IniRead, defaultPlan, PowerPlanner.ini, Settings, DefaultPlan, Power saver
IniRead, defaultGUID, PowerPlanner.ini, Settings, DefaultGUID, 0
IniRead, performanceAbove, PowerPlanner.ini, Settings, PerformanceAbove, 20
IniRead, returnBelow, PowerPlanner.ini, Settings, ReturnBelow, 10

Global Mode = Mode
Global Automatic = Automatic
Global performanceGUID = performanceGUID
Global defaultGUID = defaultGUID

if (defaultGUID = 0 || performanceGUID = 0) {
	MsgBox, Necessary configuration missing, opening settings. You will get a UAC prompt for cmd.exe, this is used to detect available power plans.
	Automatic = 0
	UpdateMenu()
	GoTo, Settings
} else {
	if(Automatic = 1){
		SetDefaultPlan()
	} else if (Mode = "Default") {
		SetDefaultPlan()
	} else if (Mode = "Performance") {
		SetPerformancePlan()
	} else {
		SetAutomatic()
	}
}

Main:
Loop {
	if (Automatic = 1){
		CPUL := CPULoad()

		if (Mode = "Default") {
			if (CPUL > performanceAbove) {
				SetPerformancePlan()
			}
		}

		if (Mode = "Performance") {
			if (CPUL < returnBelow) {
				SetDefaultPlan()
			}
		}
	}
	Sleep 5000
}

SetAutomatic(){
	Automatic = 1
	UpdateMenu()
	IniWrite, %Automatic%, PowerPlanner.ini, State, Automatic
	IniDelete, PowerPlanner.ini, State, ManualMode
}

SetPerformancePlan(){
	Mode = Performance
	UpdateMenu()
	Run powercfg.exe -setactive %performanceGUID%,,Hide
	Sleep 10000
}

SetDefaultPlan(){
	Mode = Default
	UpdateMenu()
	Run powercfg.exe -setactive %defaultGUID%,,Hide
	Sleep 10000
}

UpdateMenu(){
	Menu, Tray, DeleteAll
	Menu, Tray, Tip, Powerplanner - %Mode%
	Menu, Tray, Add, PowerPlanner, OpenTray
	Menu, Tray, Default, PowerPlanner
	Menu, Tray, Click, 1
	Menu, Tray, Add
	Menu, Tray, Add, Automatic, ToggleAutomatic
	Menu, Tray, Icon, powrprof.dll, 3
	if (Automatic = 1){
		Menu, Tray, Check, Automatic
		Menu, Tray, Disable, Automatic
	}
	Menu, Tray, Add, Performance Mode, SwitchToPerformancePlan
	if (Mode = "Performance") {
		Menu, Tray, Icon, powrprof.dll, 2
		Menu, Tray, Check, Performance Mode
	}
	Menu, Tray, Add, Default Mode, SwitchToDefaultPlan
	if (Mode = "Default"){
		Menu, Tray, Check, Default Mode
	}
	Menu, Tray, Add
	Menu, Tray, Add, Settings, Settings
	Menu, Tray, Add, Exit
}

OpenTray:
	Menu, Tray, Show
	Return

ToggleAutomatic:
	SetAutomatic()
	GoTo, Main

SwitchToPerformancePlan:
	if (performanceGUID = 0){
		GoTo, Start
	}
	Automatic = 0
	SetPerformancePlan()
	IniWrite, %Automatic%, PowerPlanner.ini, State, Automatic
	IniWrite, %Mode%, PowerPlanner.ini, State, ManualMode
	Return

SwitchToDefaultPlan:
	if (defaultGUID = 0){
		GoTo, Start
	}
	Automatic = 0
	SetDefaultPlan()
	IniWrite, %Automatic%, PowerPlanner.ini, State, Automatic
	IniWrite, %Mode%, PowerPlanner.ini, State, ManualMode
	Return

Settings:
	RunWait, *RunAs %comspec% /c C:\Windows\system32\powercfg.exe /l > C:\PowerPlannerTemp.txt
	FileRead, file, C:\PowerPlannerTemp.txt
	FileDelete, C:\PowerPlannerTemp.txt

	schemes := []

	Loop, parse, file, `n, `r  ; Specifying `n prior to `r allows both Windows and Unix files to be parsed.
	{
		;if (A_Index > 3) {
		if (RegExMatch(A_LoopField, "GUID")) {
			line := StrReplace(A_LoopField, "Power Scheme GUID: ")
			line := StrReplace(line, ")")
			line := StrReplace(line, " *")
			line := StrReplace(line, " (", ";")
			line := StrReplace(line, "RyzenT", "Ryzen")
			split := StrSplit(line, ";")
			key := split[2]
			value := split[1]
			schemes[key] := value
		}
	}

	For key, value in schemes{
	   performanceList .= key
	   performanceList .= "|"
	   if (key == performancePlan){
	   	performanceList .= "|"
	   }
	}

	For key, value in schemes{
	   defaultList .= key
	   defaultList .= "|"
	   if (key == defaultPlan){
	   	defaultList .= "|"
	   }
	}

	Gui, destroy
	Gui, Add, Text,, Default power plan:
	Gui, Add, Text,, Performance power plan:
	Gui, Add, Text,, Trigger performance:
	Gui, Add, Text,, Return to default:
	Gui, Add, DropDownList, vnewDefaultPlan ym, %defaultList%
	Gui, Add, DropDownList, vnewPerformancePlan, %performanceList%
	Gui, Add, Edit
	Gui, Add, UpDown, vnewPerformanceAbove Range1-100, %performanceAbove%
	Gui, Add, Edit
	Gui, Add, UpDown, vnewReturnBelow Range1-100, %returnBelow%
	Gui, Add, Button, default, Save
	Gui, show, AutoSize, Power Planner Settings
	Return

ButtonSave:
	Gui, Submit
	IniWrite, %newPerformancePlan%, PowerPlanner.ini, Settings, PerformancePlan
	guid := schemes[newPerformancePlan]
	IniWrite, %guid%, PowerPlanner.ini, Settings, PerformanceGUID
	IniWrite, %newDefaultPlan%, PowerPlanner.ini, Settings, DefaultPlan
	guid := schemes[newDefaultPlan]
	IniWrite, %guid%, PowerPlanner.ini, Settings, DefaultGUID
	IniWrite, %newPerformanceAbove%, PowerPlanner.ini, Settings, PerformanceAbove
	IniWrite, %newReturnBelow%, PowerPlanner.ini, Settings, ReturnBelow
	GoTo, Start

Exit:
	ExitApp

; -	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	- 

CPULoad() { ; By SKAN, CD:22-Apr-2014 / MD:05-May-2014. Thanks to ejor, Codeproject: http://goo.gl/epYnkO
Static PIT, PKT, PUT													 ; http://ahkscript.org/boards/viewtopic.php?p=17166#p17166
	IfEqual, PIT,, Return 0, DllCall( "GetSystemTimes", "Int64P",PIT, "Int64P",PKT, "Int64P",PUT )

	DllCall( "GetSystemTimes", "Int64P",CIT, "Int64P",CKT, "Int64P",CUT )
, IdleTime := PIT - CIT,		KernelTime := PKT - CKT,		UserTime := PUT - CUT
, SystemTime := KernelTime + UserTime 

Return ( ( SystemTime - IdleTime ) * 100 ) // SystemTime,		PIT := CIT,		PKT := CKT,		PUT := CUT 
} 

IsProcessElevated(ProcessID)
{
    if !(hProcess := DllCall("OpenProcess", "uint", 0x0400, "int", 0, "uint", ProcessID, "ptr"))
        throw Exception("OpenProcess failed", -1)
    if !(DllCall("advapi32\OpenProcessToken", "ptr", hProcess, "uint", 0x0008, "ptr*", hToken))
        throw Exception("OpenProcessToken failed", -1), DllCall("CloseHandle", "ptr", hProcess)
    if !(DllCall("advapi32\GetTokenInformation", "ptr", hToken, "int", 20, "uint*", IsElevated, "uint", 4, "uint*", size))
        throw Exception("GetTokenInformation failed", -1), DllCall("CloseHandle", "ptr", hToken) && DllCall("CloseHandle", "ptr", hProcess)
    return IsElevated, DllCall("CloseHandle", "ptr", hToken) && DllCall("CloseHandle", "ptr", hProcess)
}

; -	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-	-
